-- Customer Dimension (no audit, lineage)
select
	cu.CustomerID
	, cu.CustomerName
	, bg.BuyingGroupName
	, ci.CityName
	, sp.StateProvinceCode
	, sp.StateProvinceName
	, co.CountryName
	, cu.CreditLimit
from
	WideWorldImporters.sales.Customers cu
	left outer join WideWorldImporters.sales.BuyingGroups bg on bg.BuyingGroupID = cu.BuyingGroupID
	left outer join WideWorldImporters.[Application].cities ci on ci.CityID = cu.DeliveryCityID
	left outer join WideWorldImporters.[Application].StateProvinces sp on sp.StateProvinceID = ci.StateProvinceID
	left outer join WideWorldImporters.[Application].Countries co on co.CountryID = sp.CountryID

-- Customer Dimension (audit, lineage)
	, getdate() as effectiveDate
	, N'WideWorld' as sourceID
	, N'123' as ETLBatchID
	, getdate() as createDate
	, N'sreagin' as createdBy
	, getdate() as modifiedDate
	, N'sreagin' as modifiedBy

-- SQL Full Reload
insert into
	dbo.dimCustomer
select
	cu.CustomerID
	, cu.CustomerName
	, bg.BuyingGroupName
	, ci.CityName
	, sp.StateProvinceCode
	, sp.StateProvinceName
	, co.CountryName
	, cu.CreditLimit
	, getdate() as effectiveDate
	, null as obsoleteDate
	, N'WideWorld' as sourceID
	, N'123' as ETLBatchID
	, getdate() as createDate
	, N'sreagin' as createdBy
	, getdate() as modifiedDate
	, N'sreagin' as modifiedBy
from
	WideWorldImporters.sales.Customers cu
	left outer join WideWorldImporters.sales.BuyingGroups bg on bg.BuyingGroupID = cu.BuyingGroupID
	left outer join WideWorldImporters.[Application].cities ci on ci.CityID = cu.DeliveryCityID
	left outer join WideWorldImporters.[Application].StateProvinces sp on sp.StateProvinceID = ci.StateProvinceID
	left outer join WideWorldImporters.[Application].Countries co on co.CountryID = sp.CountryID

-- Invoice Line
select
	dimI.invoiceSK
	, isnull(dimCu.customerSK, 0) as customerSK
	, isnull(dimP.productSK, 0) as productSK
	, i.InvoiceDate
	, il.Quantity
	, il.UnitPrice
	, il.TaxRate
	, il.TaxAmount
	, il.LineProfit
	, il.ExtendedPrice
	, getdate() as createDate
	, 'sreagin' as createdBy
	, getdate() as modifiedDate
	, 'sreagin' as modifiedBy
from
	WideWorldImporters.sales.InvoiceLines il
	inner join WideWorldImporters.sales.Invoices i on i.InvoiceID = il.invoiceID
	inner join [PearsonLearning70-767].dbo.dimInvoice dimI on dimI.invoiceID = i.InvoiceID and dimI.obsoleteDate is null
	inner join [PearsonLearning70-767].dbo.dimCustomer dimCu on dimCu.CustomerID = i.customerID and dimCu.obsoleteDate is null
	inner join [PearsonLearning70-767].dbo.dimProduct dimP on dimP.stockItemID = il.stockItemID
		and i.InvoiceDate between dimI.effectiveDate and isnull(dimI.obsoleteDate, i.InvoiceDate)



-- Fact Tables
select concat(s.[name], '.', t.[name]) from sys.tables t inner join sys.schemas s on s.schema_id = t.schema_id
where t.[name] like 'fact%'

-- Msg Box
MsgBox(Dts.Variables("factTableName").Value.ToString)

-- Truncate Expression
"truncate table " + @[User::factTableName]

Data Source=.\sql2017;Initial Catalog=PearsonLearning70-767;Provider=SQLNCLI11.1;Integrated Security=SSPI;Auto Translate=False;